----------------------------------------------------------------
-- 
-- Copyright (c) 1995 by Altera Corporation.  All rights reserved. 
--                                                                 
-- FILENAME     :    alt_vtl.vhd (2.2b)
-- DATE CREATED :    Fri Feb 17 15:54:24 1995
-- 
-- LIBRARY      :    alt_vtl
-- REVISION     :    1.0
-- TIME SCALE   :    1 ns
-- LOGIC SYSTEM :    IEEE-1164
-- NOTES        :    VITAL, TimingChecksOn(TRUE), XGenerationOn(FALSE), On_Detect 
-- HISTORY      :
-- 
----------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.all;

library VITAL;
use VITAL.VITAL_Timing.all;
use VITAL.VITAL_Primitives.all;

package VTABLES is

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFF_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  x,  H,  x,  H ),
    ( H,  H,  x,  H,  x,  x,  S ),
    ( H,  x,  x,  L,  x,  x,  H ),
    ( H,  x,  x,  H,  L,  x,  S ),
    ( x,  L,  L,  H,  H,  x,  L ));

   CONSTANT DFFE_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  H,  L,  x,  x,  H,  H,  x,  H ),
    ( H,  H,  x,  L,  x,  H,  H,  x,  H ),
    ( H,  x,  H,  H,  H,  x,  x,  x,  S ),
    ( H,  x,  x,  x,  L,  x,  x,  x,  H ),
    ( H,  x,  x,  x,  H,  L,  x,  x,  S ),
    ( H,  x,  x,  x,  H,  x,  L,  x,  S ),
    ( x,  L,  L,  x,  H,  H,  H,  x,  L ),
    ( x,  L,  x,  L,  H,  H,  H,  x,  L ));

   CONSTANT LATCH_Q_tab : VitalStateTableType := (
    ( L,  H,  x,  L ),
    ( H,  H,  x,  H ),
    ( x,  L,  x,  S ));


end VTABLES;